package Five_bus_system
  model Network
    import Modelica.Constants.pi;
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer1(r = 0, kT = 13.8 / 230, x = 0.0586, V_b = 13.8, Vn = 13.8) annotation(
      Placement(visible = true, transformation(origin = {102, 18}, extent = {{-10, -10}, {10, 10}}, rotation = 270)));
    OpenIPSL.Electrical.Branches.PSAT.TwoWindingTransformer twoWindingTransformer2(r = 0, kT = 18 / 230, x = 0.0625, Sn = 100, V_b = 18, Vn = 18) annotation(
      Placement(visible = true, transformation(origin = {-104, 22}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
    OpenIPSL.Electrical.Loads.PSAT.VoltDependant lOADPQ1(P_0 = 100, Q_0 = 35, Sn = 100, V_b = 230) annotation(
      Placement(visible = true, transformation(origin = {7, -37}, extent = {{-7, -7}, {7, 7}}, rotation = 0)));
    inner OpenIPSL.Electrical.SystemBase SysData(S_b = 100, fn = 50) annotation(
      Placement(transformation(extent = {{80, -120}, {180, -80}})));
    Five_bus_system.Source1 source1(height_1 = 1, refdisturb_1 = true, tstart_1 = 12)  annotation(
      Placement(visible = true, transformation(origin = {-144, 78}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Five_bus_system.Source2 source21 annotation(
      Placement(visible = true, transformation(origin = {150, 78}, extent = {{-10, -10}, {10, 10}}, rotation = 180)));
  OpenIPSL.Electrical.Buses.Bus bus1(V_b = 18, displayPF = true)  annotation(
      Placement(visible = true, transformation(origin = {-104, 54}, extent = {{-10, -10}, {10, 10}}, rotation = -90)));
  OpenIPSL.Electrical.Buses.Bus bus2(V_b = 230, displayPF = true)  annotation(
      Placement(visible = true, transformation(origin = {-76, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine2_3(B = 0.0745, G = 0, R = 0.0085, X = 0.072)  annotation(
      Placement(visible = true, transformation(origin = {-40, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Branches.PwLine pwLine3_4(B = 0.1045, G = 0, R = 0.0119, X = 0.1008)  annotation(
      Placement(visible = true, transformation(origin = {40, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus3(V_b = 230, displayPF = true)  annotation(
      Placement(visible = true, transformation(origin = {-8, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus4(V_b = 230, displayPF = true)  annotation(
      Placement(visible = true, transformation(origin = {74, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  OpenIPSL.Electrical.Buses.Bus bus5(V_b = 13.8, displayPF = true)  annotation(
      Placement(visible = true, transformation(origin = {100, 48}, extent = {{-10, -10}, {10, 10}}, rotation = 90)));
  equation
    connect(bus5.p, source21.pwPin) annotation(
      Line(points = {{100, 48}, {100, 48}, {100, 78}, {140, 78}, {140, 78}}, color = {0, 0, 255}));
    connect(twoWindingTransformer1.p, bus5.p) annotation(
      Line(points = {{102, 30}, {100, 30}, {100, 48}, {100, 48}}, color = {0, 0, 255}));
    connect(bus4.p, twoWindingTransformer1.n) annotation(
      Line(points = {{74, 0}, {102, 0}, {102, 8}, {102, 8}}, color = {0, 0, 255}));
    connect(pwLine3_4.n, bus4.p) annotation(
      Line(points = {{50, 0}, {74, 0}}, color = {0, 0, 255}));
    connect(source1.pwPin, bus1.p) annotation(
      Line(points = {{-132, 78}, {-104, 78}, {-104, 54}, {-104, 54}}, color = {0, 0, 255}));
    connect(bus1.p, twoWindingTransformer2.p) annotation(
      Line(points = {{-104, 54}, {-104, 33}}, color = {0, 0, 255}));
    connect(twoWindingTransformer2.n, bus2.p) annotation(
      Line(points = {{-104, 12}, {-104, 12}, {-104, 0}, {-76, 0}, {-76, 0}}, color = {0, 0, 255}));
    connect(bus3.p, lOADPQ1.p) annotation(
      Line(points = {{-8, 0}, {6, 0}, {6, -30}, {8, -30}}, color = {0, 0, 255}));
    connect(bus3.p, pwLine3_4.p) annotation(
      Line(points = {{-8, 0}, {32, 0}, {32, 0}, {30, 0}}, color = {0, 0, 255}));
    connect(pwLine2_3.n, bus3.p) annotation(
      Line(points = {{-30, 0}, {-8, 0}, {-8, 0}, {-8, 0}}, color = {0, 0, 255}));
    connect(bus2.p, pwLine2_3.p) annotation(
      Line(points = {{-76, 0}, {-50, 0}, {-50, 0}, {-50, 0}}, color = {0, 0, 255}));
    annotation(
      Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-180, -120}, {180, 120}})),
      Icon(coordinateSystem(extent = {{-180, -120}, {180, 120}})),
      Documentation(info = "<html>
  <table cellspacing=\"2\" cellpadding=\"0\" border=\"0\"<tr>
  <td><p>Reference</p></td>
  <td><p>PSAT Manual 2.1.8</p></td>
  </tr>
  <tr>
  <td><p>Last update</p></td>
  <td><p>15/07/2015</p></td>
  </tr>
  <tr>
  <td><p>Author</p></td>
  <td><p>MAA Murad, SmarTS Lab, KTH Royal Institute of Technology</p></td>
  </tr>
  <tr>
  <td><p>Contact</p></td>
  <td><p><a href=\"mailto:luigiv@kth.se\">luigiv@kth.se</a></p></td>
  </tr>
  </table>
  </html>"),
      experiment(StopTime = 20, Interval = 0.001, Tolerance = 1e-006, __Dymola_fixedstepsize = 0.001, __Dymola_Algorithm = "Rkfix2"),
      __Dymola_experimentSetupOutput);
  end Network;

  model Source1
    extends OpenIPSL.Electrical.Essentials.pfComponent;
    parameter Real vf0 = 1.755517086537914;
    parameter Real vref0 = 1.118023800520641;
    parameter Real height_1 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Real tstart_1 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Boolean refdisturb_1 annotation(
      Dialog(group = "AVR Disturbance"));
    OpenIPSL.Electrical.Machines.PSAT.Order4 gen(Sn = 100, Vn = 18, V_b = V_b, V_0 = V_0, angle_0 = angle_0, P_0 = P_0, Q_0 = Q_0, ra = 0, xd = 0.8958, xq = 0.8645, x1d = 0.1198, x1q = 0.1969, T1d0 = 6, T1q0 = 0.5350, M = 12.8, D = 0) annotation(
      Placement(visible = true, transformation(origin = {24, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeII AVR(vrmin = -5, vrmax = 5, v0 = V_0, Ka = 20, Ta = 0.2, Kf = 0.063, Tf = 0.35, Ke = 1, Te = 0.314, Tr = 0.001, Ae = 0.0039, Be = 1.555) annotation(
      Placement(visible = true, transformation(origin = {-12, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Step step(startTime = tstart_1, offset = vref0, height = height_1) annotation(
      Placement(visible = true, transformation(origin = {-88, 16}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
    Modelica.Blocks.Logical.Switch switch1 annotation(
      Placement(visible = true, transformation(extent = {{-50, 8}, {-40, 18}}, rotation = 0)));
    Modelica.Blocks.Sources.BooleanConstant booleanConstant(k = refdisturb_1) annotation(
      Placement(visible = true, transformation(extent = {{-84, -4}, {-74, 6}}, rotation = 0)));
    OpenIPSL.Interfaces.PwPin pwPin annotation(
      Placement(transformation(extent = {{100, -10}, {120, 10}})));
    //Real P_MW;
    //Real Q_MVA;
  equation
    connect(step.y, switch1.u1) annotation(
      Line(points = {{-84, 16}, {-84, 17}, {-51, 17}}, color = {0, 0, 127}));
    connect(AVR.vref0, switch1.u3) annotation(
      Line(points = {{-12, 12}, {-12, 50}, {-68, 50}, {-68, 9}, {-51, 9}}, color = {0, 0, 127}));
    connect(booleanConstant.y, switch1.u2) annotation(
      Line(points = {{-73.5, 1}, {-62.25, 1}, {-62.25, 13}, {-51, 13}}, color = {255, 0, 255}));
    connect(switch1.y, AVR.vref) annotation(
      Line(points = {{-39.5, 13}, {-26.75, 13}, {-26.75, 6}, {-24, 6}}, color = {0, 0, 127}));
    connect(gen.vf0, AVR.vf0) annotation(
      Line(points = {{16, 12}, {16, 20}, {76, 20}, {76, -66}, {-12, -66}, {-12, -12}}, color = {0, 0, 127}));
    connect(gen.v, AVR.v) annotation(
      Line(points = {{35, 3}, {52, 3}, {52, -50}, {-38, -50}, {-38, -6}, {-24, -6}}, color = {0, 0, 127}));
    connect(AVR.vf, gen.vf) annotation(
      Line(points = {{0, 0}, {8, 0}, {8, 5}, {12, 5}}, color = {0, 0, 127}));
    connect(gen.pm0, gen.pm) annotation(
      Line(points = {{16, -11}, {16, -14}, {10, -14}, {10, -5}, {12, -5}}, color = {0, 0, 127}));
    connect(gen.p, pwPin) annotation(
      Line(points = {{34, 0}, {110, 0}}, color = {0, 0, 255}));
//P_MW = gen.P*S_b;
// Q_MVA = gen.Q*S_b;
    annotation(
      Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
      Icon(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1), graphics = {Ellipse(lineColor = {28, 108, 200}, fillPattern = FillPattern.CrossDiag, extent = {{-100, -100}, {100, 100}}, endAngle = 360), Text(lineColor = {238, 46, 47}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, extent = {{62, 106}, {134, 68}}, textString = "0.0", fontName = "0"), Text(lineColor = {0, 255, 0}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, extent = {{62, -70}, {134, -108}}, textString = "0.0", fontName = "0"), Text(origin = {-40, 16}, lineColor = {255, 255, 255}, extent = {{-30, 18}, {122, -46}}, textString = "PLANT1")}),
      Documentation);
  end Source1;

  model Source2
    extends OpenIPSL.Electrical.Essentials.pfComponent;
    parameter Real vf0 = 1.359665419632471;
    parameter Real vref0 = 1.095179545801796;
    parameter Real height_2 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Real tstart_2 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Boolean refdisturb_2 annotation(
      Dialog(group = "AVR Disturbance"));
    OpenIPSL.Electrical.Machines.PSAT.Order4 gen(Sn = 100, Vn = 13.8, V_b = V_b, V_0 = V_0, angle_0 = angle_0, P_0 = P_0, Q_0 = Q_0, ra = 0, xd = 1.3125, x1d = 0.1813, x1q = 0.25, T1d0 = 5.89, T1q0 = 0.6, M = 6.02, D = 0, xq = 1.2578) annotation(
      Placement(visible = true, transformation(origin = {30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeII AVR(vrmin = -5, vrmax = 5, v0 = V_0, Ka = 20, Ta = 0.2, Kf = 0.063, Tf = 0.35, Ke = 1, Te = 0.314, Tr = 0.001, Ae = 0.0039, Be = 1.555) annotation(
      Placement(visible = true, transformation(origin = {-14, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
    Modelica.Blocks.Sources.Step step(startTime = tstart_2, height = height_2, offset = vref0) annotation(
      Placement(visible = true, transformation(origin = {-88, 14}, extent = {{-4, -4}, {4, 4}}, rotation = 0)));
    Modelica.Blocks.Logical.Switch switch1 annotation(
      Placement(visible = true, transformation(extent = {{-56, -6}, {-46, 4}}, rotation = 0)));
    Modelica.Blocks.Sources.BooleanConstant booleanConstant(k = refdisturb_2) annotation(
      Placement(visible = true, transformation(extent = {{-90, -6}, {-80, 4}}, rotation = 0)));
    OpenIPSL.Interfaces.PwPin pwPin annotation(
      Placement(transformation(extent = {{100, -10}, {120, 10}})));
    //Real P_MW;
    //Real Q_MVA;
  equation
    connect(AVR.v, gen.v) annotation(
      Line(points = {{-26, -6}, {-34, -6}, {-34, -32}, {56, -32}, {56, 2}, {42, 2}, {42, 4}}, color = {0, 0, 127}));
    connect(switch1.u3, AVR.vref0) annotation(
      Line(points = {{-56, -4}, {-66, -4}, {-66, 28}, {-14, 28}, {-14, 12}}, color = {0, 0, 127}));
    connect(gen.vf0, AVR.vf0) annotation(
      Line(points = {{22, 12}, {22, 16}, {66, 16}, {66, -58}, {-14, -58}, {-14, -12}}, color = {0, 0, 127}));
    connect(AVR.vf, gen.vf) annotation(
      Line(points = {{-2, 0}, {8, 0}, {8, 5}, {18, 5}}, color = {0, 0, 127}));
    connect(switch1.y, AVR.vref) annotation(
      Line(points = {{-45.5, -1}, {-26.75, -1}, {-26.75, 6}, {-26, 6}}, color = {0, 0, 127}));
    connect(gen.pm0, gen.pm) annotation(
      Line(points = {{22, -11}, {22, -14}, {14, -14}, {14, -5}, {18, -5}}, color = {0, 0, 127}));
    connect(gen.p, pwPin) annotation(
      Line(points = {{40, 0}, {110, 0}}, color = {0, 0, 255}));
    connect(step.y, switch1.u1) annotation(
      Line(points = {{-84, 14}, {-84, 14.5}, {-70, 14.5}, {-70, 3}, {-57, 3}}, color = {0, 0, 127}));
    connect(booleanConstant.y, switch1.u2) annotation(
      Line(points = {{-79.5, -1}, {-57, -1}}, color = {255, 0, 255}));
//P_MW = gen.P*S_b;
//Q_MVA = gen.Q*S_b;
    annotation(
      Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
      Icon(coordinateSystem(preserveAspectRatio = false, initialScale = 0.1), graphics = {Ellipse(lineColor = {28, 108, 200}, fillPattern = FillPattern.CrossDiag, extent = {{-100, -100}, {100, 100}}, endAngle = 360), Text(lineColor = {238, 46, 47}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, extent = {{62, 106}, {134, 68}}, textString = "0.0", fontName = "0"), Text(lineColor = {0, 255, 0}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, extent = {{62, -70}, {134, -108}}, textString = "0.0", fontName = "0"), Text(origin = {7, 4}, lineColor = {255, 255, 255}, extent = {{-85, 42}, {73, -40}}, textString = "PLANT2")}),
      Documentation);
  end Source2;

  model plant3
    extends OpenIPSL.Electrical.Essentials.pfComponent;
    parameter Real vf0 = 1.079018784709528;
    parameter Real vref0 = 1.095077501312303;
    parameter Real height_3 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Real tstart_3 annotation(
      Dialog(group = "AVR Disturbance"));
    parameter Boolean refdisturb_3 annotation(
      Dialog(group = "AVR Disturbance"));
    OpenIPSL.Electrical.Machines.PSAT.Order4 gen(Sn = 100, ra = 0, xd = 0.1460, xq = 0.0969, x1d = 0.0608, x1q = 0.0969, T1d0 = 8.96, T1q0 = 0.310, V_b = V_b, V_0 = V_0, P_0 = P_0, Q_0 = Q_0, M = 47.28, D = 0, Vn = 16.5, angle_0 = angle_0) annotation(
      Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {28, 14})));
    OpenIPSL.Electrical.Controls.PSAT.AVR.AVRTypeII AVR(vrmin = -5, vrmax = 5, v0 = V_0, Ka = 20, Ta = 0.2, Kf = 0.063, Tf = 0.35, Ke = 1, Te = 0.314, Tr = 0.001, Ae = 0.0039, Be = 1.555) annotation(
      Placement(transformation(extent = {{-10, -10}, {10, 10}}, rotation = 0, origin = {-6, 10})));
    Modelica.Blocks.Sources.Step step(startTime = tstart_3, height = height_3, offset = vref0) annotation(
      Placement(transformation(extent = {{-4, -4}, {4, 4}}, rotation = 0, origin = {-66, 30})));
    Modelica.Blocks.Logical.Switch switch1 annotation(
      Placement(transformation(extent = {{-50, 12}, {-40, 22}})));
    Modelica.Blocks.Sources.BooleanConstant booleanConstant(k = refdisturb_3) annotation(
      Placement(transformation(extent = {{-72, 12}, {-62, 22}})));
    OpenIPSL.Interfaces.PwPin pwPin annotation(
      Placement(transformation(extent = {{100, -10}, {120, 10}})));
    //Real P_MW;
    //Real Q_MVA;
  equation
//P_MW = gen.P*S_b;
//Q_MVA = gen.Q*S_b;
    connect(gen.v, AVR.v) annotation(
      Line(points = {{39, 17}, {48, 17}, {48, -14}, {-22, -14}, {-22, 4}, {-18, 4}}, color = {0, 0, 127}, smooth = Smooth.None));
    connect(switch1.y, AVR.vref) annotation(
      Line(points = {{-39.5, 17}, {-26.75, 17}, {-26.75, 16}, {-18, 16}}, color = {0, 0, 127}));
    connect(booleanConstant.y, switch1.u2) annotation(
      Line(points = {{-61.5, 17}, {-61.5, 17}, {-51, 17}}, color = {255, 0, 255}));
    connect(step.y, switch1.u1) annotation(
      Line(points = {{-61.6, 30}, {-56, 30}, {-56, 21}, {-51, 21}}, color = {0, 0, 127}));
    connect(gen.p, pwPin) annotation(
      Line(points = {{38, 14}, {66, 14}, {66, 0}, {110, 0}}, color = {0, 0, 255}));
    connect(AVR.vf, gen.vf) annotation(
      Line(points = {{6, 10}, {8, 10}, {8, 19}, {16, 19}}, color = {0, 0, 127}));
    connect(gen.pm0, gen.pm) annotation(
      Line(points = {{20, 3}, {20, 0}, {14, 0}, {14, 9}, {16, 9}}, color = {0, 0, 127}));
    connect(AVR.vf0, gen.vf0) annotation(
      Line(points = {{-6, -2}, {-6, -2}, {-6, -10}, {-92, -10}, {-92, 6}, {-92, 42}, {20, 42}, {20, 25}}, color = {0, 0, 127}));
    connect(AVR.vref0, switch1.u3) annotation(
      Line(points = {{-6, 22}, {-6, 22}, {-6, 36}, {-84, 36}, {-84, 2}, {-56, 2}, {-56, 13}, {-51, 13}}, color = {0, 0, 127}));
    annotation(
      Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}})),
      Icon(coordinateSystem(preserveAspectRatio = false, extent = {{-100, -100}, {100, 100}}), graphics = {Ellipse(extent = {{-100, -100}, {100, 100}}, lineColor = {28, 108, 200}), Line(points = {{-60, -20}, {-20, 20}, {20, -20}, {60, 20}}, color = {28, 108, 200}), Text(extent = {{-34, -32}, {38, -52}}, lineColor = {28, 108, 200}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = "%name"), Text(extent = {{62, 106}, {134, 68}}, lineColor = {238, 46, 47}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = DynamicSelect("0.0", String(P_MW, significantDigits = 3))), Text(extent = {{62, -70}, {134, -108}}, lineColor = {0, 255, 0}, fillColor = {0, 0, 255}, fillPattern = FillPattern.Solid, textString = DynamicSelect("0.0", String(Q_MVA, significantDigits = 3)))}),
      Documentation);
  end plant3;
  annotation(
    uses(OpenIPSL(version = "1.0.0")));
end Five_bus_system;
